/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal.xmllite;

public class CharString {
    private char[] value;
    private int start;
    private int length;

    public CharString(String string) {
        this.start = 0;
        this.length = string.length();
        this.value = new char[this.length];
        string.getChars(0, this.length, this.value, this.start);
    }

    public CharString(char[] cArray, int n, int n2) {
        this.value = cArray;
        this.start = n;
        this.length = n2;
    }

    public CharString(CharString charString) {
        this.start = 0;
        this.length = charString.length;
        this.value = new char[this.length];
        int[] nArray = new int[2];
        charString.computeChunkLengths(nArray);
        System.arraycopy(charString.value, charString.start, this.value, this.start, nArray[0]);
        if (nArray[1] != 0) {
            System.arraycopy(charString.value, 0, this.value, nArray[0], nArray[1]);
        }
    }

    public CharString trim() {
        while (this.length > 0) {
            if (!Character.isWhitespace(this.value[this.start])) break;
            ++this.start;
            if (this.start == this.value.length) {
                this.start = 0;
            }
            --this.length;
        }
        int n = this.start + this.length - 1;
        if (n >= this.value.length) {
            n -= this.value.length;
        }
        while (this.length > 0) {
            if (!Character.isWhitespace(this.value[n])) break;
            if (--n == -1) {
                n = this.value.length - 1;
            }
            --this.length;
        }
        return this;
    }

    public boolean equals(Object object) {
        CharString charString;
        if (object == null) {
            return false;
        }
        try {
            charString = (CharString)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.length != charString.length) {
            return false;
        }
        int n = 0;
        int n2 = this.start;
        int n3 = charString.start;
        while (n < this.length) {
            if (this.value[n2] != charString.value[n3]) {
                return false;
            }
            ++n;
            if (++n2 == this.value.length) {
                n2 = 0;
            }
            if (++n3 != charString.value.length) continue;
            n3 = 0;
        }
        return true;
    }

    public String toString() {
        int[] nArray = new int[2];
        this.computeChunkLengths(nArray);
        StringBuffer stringBuffer = new StringBuffer(this.length);
        stringBuffer.append(this.value, this.start, nArray[0]);
        if (nArray[1] != 0) {
            stringBuffer.append(this.value, 0, nArray[1]);
        }
        return stringBuffer.toString();
    }

    public int toInt() throws NumberFormatException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.start;
        int n4 = this.length;
        if (n4 > 0) {
            int n5;
            int n6;
            if (this.value[this.start] == '-') {
                bl = true;
                n6 = Integer.MIN_VALUE;
                ++n2;
                if (++n3 == this.value.length) {
                    n3 = 0;
                }
            } else {
                n6 = -2147483647;
            }
            int n7 = n6 / 10;
            if (n2 < n4) {
                n5 = Character.digit(this.value[n3], 10);
                ++n2;
                if (++n3 == this.value.length) {
                    n3 = 0;
                }
                if (n5 < 0) {
                    throw new NumberFormatException(this.toString());
                }
                n = -n5;
            }
            while (n2 < n4) {
                n5 = Character.digit(this.value[n3], 10);
                ++n2;
                if (++n3 == this.value.length) {
                    n3 = 0;
                }
                if (n5 < 0) {
                    throw new NumberFormatException(this.toString());
                }
                if (n < n7) {
                    throw new NumberFormatException(this.toString());
                }
                if ((n *= 10) < n6 + n5) {
                    throw new NumberFormatException(this.toString());
                }
                n -= n5;
            }
        } else {
            throw new NumberFormatException(this.toString());
        }
        if (bl) {
            if (n2 > 1) {
                return n;
            }
            throw new NumberFormatException(this.toString());
        }
        return -n;
    }

    private void computeChunkLengths(int[] nArray) {
        nArray[0] = this.value.length - this.start;
        if (nArray[0] < this.length) {
            nArray[1] = this.length - nArray[0];
        } else {
            nArray[0] = this.length;
            nArray[1] = 0;
        }
    }
}

